/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplicationInnerClasses;

import java.util.function.Predicate;
import products.*;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestPriceList {

    public static void main(String[] args) {
        PriceList demo = (new InMemoryDataSource()).retrieveList("Demo");
//        demo.printList(); 

        //Using Labmda Expression
//        demo.filterList(i-> i instanceof WritingImplement).printList();
        //The old way
        //1. Using Outer Class
//        Condition filter = new Condition();
//        demo.filterList(filter).printList();
        //2.  Using an interface for flexibility - test any condition related to Item
//        ConditionWithInterface filter = new ConditionWithInterface();
//        demo.filterList(filter).printList();
        //3.  Using Generics for even more flex - create tests for any kind of class not just Item
//        ConditionWithGenericInterface filter = new ConditionWithGenericInterface();
//        demo.filterList(filter).printList();
        //4.  Using Inner Classes for convenience - create only as and when it is needed.
//        class LocalCondition implements GenericFilter<Item>{
//                public boolean test(Item i) {
//                    return (i instanceof WritingImplement);
//                }
//        }
//        LocalCondition filter = new LocalCondition();
//        demo.filterList(filter).printList();
        //6.  Using JavaSE8's  interface.
        class LocalCondition implements Predicate<Item>{
                public boolean test(Item i) {
                    return (i instanceof WritingImplement);
                }
        }
        LocalCondition filter = new LocalCondition();
        demo.filterList(filter).printList();
        //The rest of the examples can be found in the salesApplicationFinal pacakge. 
        
    }
}
